' Note! Changer l'espace de nom racine vers MyStatusBar afin
' d'viter une confusion de nom avec le type StatusBar.

Public Class Form1
    Inherits System.Windows.Forms.Form

    ' Donnes membres pour la barre d'tat et chaque panneau.
    Private statBar As StatusBar = New StatusBar()
    Private sbPnlPrompt As StatusBarPanel = New StatusBarPanel()
    Private sbPnlTime As StatusBarPanel = New StatusBarPanel()

    ' Timer
    Private WithEvents timer1 As Timer = New Timer()
    
    ' Le menu principal du formulaire.
    Private mnuMain As MainMenu = New MainMenu()

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()
        Me.BackColor = Color.DodgerBlue
        'Cet appel est requis par le concepteur Windows Form.
        InitializeComponent()

        ' Crer la barre d'tat.
        BuildStatBar()

        ' Crer le menu.
        BuildMenuSystem()

        ' Configurer le timer.
        timer1.Interval = 1000
        timer1.Enabled = True

    End Sub

    'La classe Form surcharge la mthode dispose pour nettoyer la liste de composants.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Requis par le Concepteur Windows Form
    Private components As System.ComponentModel.Container

    'NOTE: La procdure suivante est requise par le Concepteur Windows Form
    'Elle peut tre modifie en utilisant le Concepteur Windows Form.  
    'Ne pas la modifier en utilisant le Concepteur Windows Form.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(292, 273)
        Me.Name = "Form1"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "Formulaire StatusBar"

    End Sub

#End Region


    Private Sub BuildStatBar()
        ' Configurer la barre d'tat.
        statBar.ShowPanels = True
        statBar.Size = New System.Drawing.Size(212, 20)
        statBar.Location = New System.Drawing.Point(0, 216)

        ' AddRange() permet d'ajouter plusieurs panneaux en mme temps.
        statBar.Panels.AddRange(New StatusBarPanel() _
            {sbPnlPrompt, sbPnlTime})

        ' Configurer le panneau d'affichage.
        sbPnlPrompt.BorderStyle = StatusBarPanelBorderStyle.None
        sbPnlPrompt.AutoSize = StatusBarPanelAutoSize.Spring
        sbPnlPrompt.Width = 62
        sbPnlPrompt.Text = "Prt"

        ' Configurer le panneau horloge.
        sbPnlTime.Alignment = HorizontalAlignment.Right
        sbPnlTime.Width = 76

        ' Ajouter une icne (plus de dtails dans le chapitre 9).
        Try
            ' Cette icne doit tre dans le mme rpertoire que l'application.
            ' Le chapitre 9 illustrera la faon d'encapsuler des ressources
            ' dans vos assemblys !
            Dim i As Icon = New Icon("status.ico")
            sbPnlPrompt.Icon = i
        Catch e As Exception
            MessageBox.Show(e.Message)
        End Try

        ' Maintenant ajouter cette nouvelle barre d'tat  la collection de contrles du formulaire.
        Me.Controls.Add(statBar)
    End Sub

    Private Sub GetTime(ByVal sender As Object, ByVal e As EventArgs) Handles timer1.Tick
        Dim t As DateTime = DateTime.Now
        Dim s As String = t.ToLongTimeString()

        ' Changer le texte du panneau pour l'heure actuelle.
        sbPnlTime.Text = s
    End Sub

    Private Sub BuildMenuSystem()
        ' Crer le menu "Fichier" et l'ajouter au MenuItemCollection.
        Dim miFile As MenuItem = mnuMain.MenuItems.Add("&Fichier")

        ' Maintenant crer le sous-menu "Fichier | Quitter" et l'ajouter au menu Fichier.
        miFile.MenuItems.Add(New MenuItem("&Quitter", _
                                New EventHandler(AddressOf FileExit_Clicked), _
                                Shortcut.CtrlX))
        ' Ajouter dynamiquement un gestionnaire pour l'vnement Select !
        AddHandler miFile.MenuItems(0).Select, AddressOf FileExit_Selected

        ' Maintenant crer un menu "Aide | A propos".
        Dim miHelp As MenuItem = mnuMain.MenuItems.Add("Aide")
        miHelp.MenuItems.Add(New MenuItem("&A Propos", _
                New EventHandler(AddressOf HelpAbout_Clicked), _
                Shortcut.CtrlA))
        ' Ajouter dynamiquement un gestionnaire pour l'vnement Select!
        AddHandler miHelp.MenuItems(0).Select, AddressOf HelpAbout_Selected
        ' Attacher le menu principal  l'objet Form. 
        Me.Menu = mnuMain
    End Sub

    Private Sub FileExit_Clicked(ByVal sender As Object, ByVal e As EventArgs)
        mnuMain.GetForm().BackColor = Color.Black
        MessageBox.Show("La couleur d'arrire-plan a t modifie via l'objet menu.")
        Me.Close() ' Fermer simplement l'application
    End Sub

    Private Sub HelpAbout_Clicked(ByVal sender As Object, ByVal e As EventArgs)
        MessageBox.Show("L'tonnante application menu...")
    End Sub

    Private Sub Form1_MenuComplete(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.MenuComplete
        ' L'vnement MenuComplete est envoy lorsque l'utilisateur dsactive le 
        ' menu. Nous voulons capturer cet vnement afin d'affecter la valeur
        ' "Prt" au premier panneau. Dans le cas contraire, le texte de 
        ' StatusBarPanel serait toujours bas sur le dernier lment
        ' de menu slectionn!
        sbPnlPrompt.Text = "Prt"
    End Sub
    Private Sub FileExit_Selected(ByVal sender As Object, ByVal e As EventArgs)
        sbPnlPrompt.Text = "Terminer ce programme"
    End Sub

    Private Sub HelpAbout_Selected(ByVal sender As Object, ByVal e As EventArgs)
        sbPnlPrompt.Text = "Afficher des infos sur l'application"
    End Sub

End Class
